package coreservlets.tags;

import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.*;
import java.io.*;
import javax.servlet.http.*;

/**
 *  Znacznik DebugTag zwraca swoj tre, jeeli w daniu
 *  obecny jest parametr 'debug'. Jeeli w daniu parametr
 *  nie wystpuje, tre znacznika jest pomijana.
 *  <P>
 *  Taken from Core Servlets and JavaServer Pages Volume II
 *  from Prentice Hall and Sun Microsystems Press,
 *  http://volume2.coreservlets.com/.
 *  (C) 2007 Marty Hall, Larry Brown, and Yaakov Chaikin;
 *  may be freely used or adapted.
 */
public class DebugTag extends SimpleTagSupport {
  public void doTag() throws JspException, IOException {
    PageContext context = (PageContext)getJspContext();
    HttpServletRequest request =
      (HttpServletRequest)context.getRequest();
    // Tre znacznika zwracana tylko, gdy obecny jest parametr debug.
    if (request.getParameter("debug") != null) {
      getJspBody().invoke(null);
    }
  }
}
